package mocks

import mock "github.com/stretchr/testify/mock"
import s3 "code.justin.tv/web/users-service/internal/clients/s3"

// S3Client is an autogenerated mock type for the S3Client type
type S3Client struct {
	mock.Mock
}

// BatchCopy provides a mock function with given fields: paths
func (_m *S3Client) BatchCopy(paths map[string]string) error {
	ret := _m.Called(paths)

	var r0 error
	if rf, ok := ret.Get(0).(func(map[string]string) error); ok {
		r0 = rf(paths)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// BatchDelete provides a mock function with given fields: paths
func (_m *S3Client) BatchDelete(paths []string) error {
	ret := _m.Called(paths)

	var r0 error
	if rf, ok := ret.Get(0).(func([]string) error); ok {
		r0 = rf(paths)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ s3.S3Client = (*S3Client)(nil)
