package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"

// Publisher is an autogenerated mock type for the Publisher type
type Publisher struct {
	mock.Mock
}

// PublishBan provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishBan(ctx context.Context, e models.SNSBanEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSBanEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishBanUser provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishBanUser(ctx context.Context, e models.SNSBanUserEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSBanUserEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishChannelUpdate provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishChannelUpdate(ctx context.Context, e models.SNSChannelUpdateEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSChannelUpdateEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishCreation provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishCreation(ctx context.Context, e models.SNSCreationEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSCreationEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishExpireCache provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishExpireCache(ctx context.Context, e models.SNSExpireCacheEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSExpireCacheEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishHardDelete provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishHardDelete(ctx context.Context, e models.SNSHardDeleteEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSHardDeleteEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishImageUpdate provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishImageUpdate(ctx context.Context, e models.SNSUpdateImageEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSUpdateImageEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishRename provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishRename(ctx context.Context, e models.SNSRenameEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSRenameEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishSoftDelete provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishSoftDelete(ctx context.Context, e models.SNSSoftDeleteEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSSoftDeleteEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishUnban provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishUnban(ctx context.Context, e models.SNSUnbanEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSUnbanEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishUndelete provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishUndelete(ctx context.Context, e models.SNSUndeleteEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSUndeleteEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishUpdate provides a mock function with given fields: ctx, e
func (_m *Publisher) PublishUpdate(ctx context.Context, e models.SNSUpdateEvent) error {
	ret := _m.Called(ctx, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.SNSUpdateEvent) error); ok {
		r0 = rf(ctx, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
