package sqs

import (
	"net"
	"net/http"
	"time"

	"code.justin.tv/chat/golibs/errx"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sqs"
	"github.com/aws/aws-sdk-go/service/sqs/sqsiface"
)

const (
	sqsError = "sqs_err"
)

type Config struct {
	Region      string
	Endpoint    string
	Credentials *credentials.Credentials
}

// NewSQSClient instantiates a new SQS Client
func NewSQSClient(c Config) (sqsiface.SQSAPI, error) {
	httpClient := &http.Client{
		Transport: &http.Transport{
			Proxy: http.ProxyFromEnvironment,
			DialContext: (&net.Dialer{
				Timeout:   5 * time.Second,
				KeepAlive: 30 * time.Second,
			}).DialContext,
			TLSHandshakeTimeout: 10 * time.Second,
			MaxIdleConnsPerHost: 5000,
		},
	}
	var endpoint *string
	if c.Endpoint != "" {
		endpoint = aws.String(c.Endpoint)
	}

	sess := session.New(&aws.Config{
		HTTPClient:  httpClient,
		Region:      aws.String(c.Region),
		Endpoint:    endpoint,
		Credentials: c.Credentials,
	})
	if sess == nil {
		return nil, errx.New(errx.Fields{sqsError: "creating SQS client"})
	}
	return sqs.New(sess), nil
}
