package twilio

import (
	"errors"
	"testing"
)

func TestClientNumber(t *testing.T) {
	c := &client{
		fromChoices: []string{"a", "b", "c", "d"},
	}

	num := c.number("asdf")
	for i := 0; i < 10; i++ {
		if c.number("asdf") != num {
			t.Error("got different number than expected")
		}
	}
}

func TestIsInvalidPhoneNumber(t *testing.T) {
	if !isInvalidPhoneNumber(errors.New("is not a valid phone number")) {
		t.Error("valid phone number failed")
	}

	if !isInvalidPhoneNumber(errors.New("is not a mobile number")) {
		t.Error("mobile number failed")
	}

	if isInvalidPhoneNumber(errors.New("we are down")) {
		t.Error("we are down failed")
	}
}
