package mocks

import context "context"
import mock "github.com/stretchr/testify/mock"
import twilio "code.justin.tv/web/users-service/internal/clients/twilio"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// SendSMS provides a mock function with given fields: ctx, number, body
func (_m *Client) SendSMS(ctx context.Context, number string, body string) error {
	ret := _m.Called(ctx, number, body)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = rf(ctx, number, body)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ twilio.Client = (*Client)(nil)
