package mocks

import clientsuploader "code.justin.tv/web/users-service/internal/clients/uploader"
import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"
import uploader "code.justin.tv/web/upload-service/rpc/uploader"

// Uploader is an autogenerated mock type for the Uploader type
type Uploader struct {
	mock.Mock
}

// UpdateStatus provides a mock function with given fields: ctx, uploadID, status
func (_m *Uploader) UpdateStatus(ctx context.Context, uploadID string, status uploader.Status) error {
	ret := _m.Called(ctx, uploadID, status)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, uploader.Status) error); ok {
		r0 = rf(ctx, uploadID, status)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UploadImages provides a mock function with given fields: ctx, uploadableImage
func (_m *Uploader) UploadImages(ctx context.Context, uploadableImage models.UploadableImage) (models.UploadInfo, error) {
	ret := _m.Called(ctx, uploadableImage)

	var r0 models.UploadInfo
	if rf, ok := ret.Get(0).(func(context.Context, models.UploadableImage) models.UploadInfo); ok {
		r0 = rf(ctx, uploadableImage)
	} else {
		r0 = ret.Get(0).(models.UploadInfo)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, models.UploadableImage) error); ok {
		r1 = rf(ctx, uploadableImage)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

var _ clientsuploader.Uploader = (*Uploader)(nil)
