// errors.go contains common code for dealing with errors.
package errlog

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/web/users-service/internal/utils"
)

// FromChannel logs errors from an channel until the channel is closed.
// Run in a goroutine to log in a non-blocking way.
func FromChannel(ctx context.Context, errCh <-chan error) {
	for {
		select {
		case <-ctx.Done():
			return
		case err, ok := <-errCh:
			if !ok {
				return
			}
			if err != nil && !utils.IsKnownErr(err) {
				logx.Error(ctx, err)
			}
		}
	}
}
