package image

import (
	"encoding/json"

	"fmt"
	"strconv"

	"code.justin.tv/common/yimg"
)

var DefaultProfileImageKeys []string
var DefaultProfileImages map[string]*yimg.Images
var DefaultProfileBanners map[string]*yimg.Images
var DefaultChannelOfflineImages map[string]*yimg.Images

const (
	ClearProfileImage        = "empty_profile_image"
	ClearProfileBanner       = "empty_profile_banner"
	ClearChannelOfflineImage = "empty_channel_offline_image"

	DefaultProfileImage        = "default_profile_image"
	DefaultProfileBanner       = "default_profile_banner"
	DefaultChannelOfflineImage = "default_channel_offline_image"
)

func SetUpImageReader() error {
	DefaultProfileBanners = map[string]*yimg.Images{}
	DefaultChannelOfflineImages = map[string]*yimg.Images{}
	DefaultProfileImages = map[string]*yimg.Images{}

	bytes, err := Asset("channel_offline_images.json")
	if err != nil {
		return err
	}

	err = json.Unmarshal(bytes, &DefaultChannelOfflineImages)
	if err != nil {
		return err
	}

	bytes, err = Asset("profile_banners.json")
	if err != nil {
		return err
	}

	err = json.Unmarshal(bytes, &DefaultProfileBanners)
	if err != nil {
		return err
	}

	bytes, err = Asset("profile_images.json")
	if err != nil {
		return err
	}

	err = json.Unmarshal(bytes, &DefaultProfileImages)
	if err != nil {
		return err
	}

	for key := range DefaultProfileImages {
		DefaultProfileImageKeys = append(DefaultProfileImageKeys, key)
	}

	return nil
}

func GetProfileImages(image *string, login, id string) (*yimg.Images, *string, error) {
	if image == nil {
		randomDefaultImage, randomeDefaultNo := GetRandomProfileImage(id)
		return randomDefaultImage, &randomeDefaultNo, nil
	}

	pi, err := yimg.ProfileImages([]byte(*image), login)
	if err != nil {
		if val, ok := DefaultProfileImages[*image]; ok {
			return val, image, nil
		} else {
			return nil, nil, err
		}
	}
	return &pi, nil, nil
}

func GetChannelOfflineImages(image *string, login string) (*yimg.Images, *string, error) {
	if image == nil {
		return nil, nil, nil
	}

	pi, err := yimg.ChannelOfflineImages([]byte(*image), login)
	if err != nil {
		if val, ok := DefaultChannelOfflineImages[*image]; ok {
			return val, image, nil
		} else {
			return nil, nil, err
		}
	}
	return &pi, nil, nil
}

func GetProfileBanners(image *string, login string) (*yimg.Images, *string, error) {
	if image == nil {
		return nil, nil, nil
	}

	pi, err := yimg.ProfileBanners([]byte(*image), login)
	if err != nil {
		if val, ok := DefaultProfileBanners[*image]; ok {
			return val, image, nil
		} else {
			return nil, nil, err
		}
	}
	return &pi, nil, nil
}

func GetRandomProfileImage(userID string) (*yimg.Images, string) {
	intID, err := strconv.Atoi(userID)
	if err != nil {
		intID = 1
	}
	id := fmt.Sprintf("profile_image_%03.f", float32(intID%(len(DefaultProfileImages)-1)+1))
	return DefaultProfileImages[id], id
}
