package testutils

import (
	"code.justin.tv/web/users-service/models"
)

const (
	AdminUserID            = "51756334"
	ToRenameUserID         = "136138037"
	ToBanUserID            = "121220720"
	ToSetPropUserID        = "14747915"
	ToAddDMCAUserID        = "134661843"
	LoginLikePrefixPattern = "mellified%"
	PhoneNumberUserID      = "121220720"
	ToSetChannelPropUserID = "121266720"
	GonerUserID            = "134661845"

	IntToSetPropUserID = 14747915
)

var Users map[string]*models.Properties
var PrivilegedUsers *models.GlobalPrivilegedUsers
var Channels map[string]models.ChannelProperties

func init() {
	setupUsers()
	setupGlobalPrivilegedUsers()
	setupChannels()
}

func setupUsers() {
	Users = map[string]*models.Properties{}
	ReadToStruct(TestDataPath, "users.json", &Users)
}

func setupGlobalPrivilegedUsers() {
	PrivilegedUsers = &models.GlobalPrivilegedUsers{}
	ReadToStruct(TestDataPath, "globalprivilegedusers.json", PrivilegedUsers)
}

func setupChannels() {
	Channels = map[string]models.ChannelProperties{}
	ReadToStruct(TestDataPath, "channels.json", &Channels)
}
