package utils

import (
	"errors"
	"testing"
)

func TestIsTimeoutErr(t *testing.T) {
	tests := []struct {
		name string
		err  error
		want bool
	}{
		{
			name: "is",
			err:  errors.New("read tcp 10.194.211.47:55189->10.196.72.123:17850: i/o timeout"),
			want: true,
		},
		{
			name: "isn't",
			err:  errors.New("error unmarshaling json"),
			want: false,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := IsTimeoutErr(tt.err); got != tt.want {
				t.Errorf("isTimeoutErr() = %v, want %v", got, tt.want)
			}
		})
	}
}
