package worker

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/internal/clients/cache/rediscacher"
	"code.justin.tv/web/users-service/internal/clients/pubsub"
	"code.justin.tv/web/users-service/internal/clients/s3"
	"code.justin.tv/web/users-service/internal/clients/sqs"
	"code.justin.tv/web/users-service/internal/clients/uploader"
	"code.justin.tv/web/users-service/logic"
	"github.com/aws/aws-sdk-go/service/sqs/sqsiface"
	"github.com/cactus/go-statsd-client/statsd"
)

const (
	EmailValidationQueue = "EmailValidationQueue"
	ImageUploadQueue     = "ImageUploadQueue"
)

// Clients stores interfaces used by Users Service workers.
type Clients struct {
	SQS                   sqsiface.SQSAPI
	Stats                 statsd.Statter
	Users                 logic.Logic
	Uploader              uploader.Uploader
	S3                    s3.S3Client
	Topics                map[string]string
	PubSub                pubsub.PubSub
	LocalExpirationCacher rediscacher.LocalExpirationCacher
}

// InitClients returns interfaces used by Users Service workers.
func InitClients(conf Configs) (Clients, error) {
	sqsClient, err := sqs.NewSQSClient(sqs.Config{
		Region:   conf.SQSRegion,
		Endpoint: conf.SQSEndpoint,
	})
	if err != nil {
		return Clients{}, errx.New(err)
	}

	return Clients{
		SQS:                   sqsClient,
		Stats:                 conf.Stats,
		Users:                 conf.Users,
		Uploader:              conf.Uploader,
		S3:                    conf.S3,
		Topics:                conf.Topics,
		PubSub:                conf.PubSub,
		LocalExpirationCacher: conf.LocalExpirationCacher,
	}, nil
}
