package worker

import (
	"code.justin.tv/web/users-service/internal/clients/cache/rediscacher"
	"code.justin.tv/web/users-service/internal/clients/pubsub"
	"code.justin.tv/web/users-service/internal/clients/s3"
	"code.justin.tv/web/users-service/internal/clients/uploader"
	"code.justin.tv/web/users-service/logic"
	"github.com/cactus/go-statsd-client/statsd"
)

// Configs defines configurable values for the Users Service workers.
// All SQS queue name fields should contain "QueueName"
type Configs struct {
	SQSRegion             string
	SQSEndpoint           string
	Stats                 statsd.Statter
	Users                 logic.Logic
	Uploader              uploader.Uploader
	S3                    s3.S3Client
	Topics                map[string]string
	LocalExpirationCacher rediscacher.LocalExpirationCacher
	PubSub                pubsub.PubSub
}
