package deadletterqueue_test

import (
	"context"
	"testing"

	"errors"

	rpcuploader "code.justin.tv/web/upload-service/rpc/uploader"
	s3mock "code.justin.tv/web/users-service/internal/clients/s3/mocks"
	uploadermock "code.justin.tv/web/users-service/internal/clients/uploader/mocks"
	"code.justin.tv/web/users-service/internal/worker"
	"code.justin.tv/web/users-service/internal/worker/deadletterqueue"
	"code.justin.tv/web/users-service/internal/worker/snsmodels"
	logicmock "code.justin.tv/web/users-service/logic/mocks"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type DeadLetterWorkerTest struct {
	suite.Suite
	msg      snsmodels.Message
	c        worker.Clients
	users    *logicmock.Logic
	uploader *uploadermock.Uploader
	s3       *s3mock.S3Client
	topics   map[string]string
}

func (suite *DeadLetterWorkerTest) SetupTest() {
	suite.msg = snsmodels.Message{}
	suite.users = &logicmock.Logic{}
	suite.uploader = &uploadermock.Uploader{}
	suite.s3 = &s3mock.S3Client{}
	suite.topics = map[string]string{worker.ImageUploadQueue: "imagequeue", worker.EmailValidationQueue: "emailqueue"}
	suite.c = worker.Clients{
		Users:    suite.users,
		Uploader: suite.uploader,
		S3:       suite.s3,
		Topics:   suite.topics,
	}
}

func (suite *DeadLetterWorkerTest) TestSuccessUploadWorkerRun() {
	suite.msg.TopicARN = "imagequeue"
	suite.msg.Message = "{\"upload_id\":\"84acfdfb-e2e8-4a88-b9ed-d466b9f7ef78\",\"output_paths\":[\"s3://ttv-user-pictures-prod/e1cd1506e666a57b-profile_image-150x150.jpeg\",\"s3://ttv-user-pictures-prod/e1cd1506e666a57b-profile_image-300x300.jpeg\"]}"
	suite.uploader.On("UpdateStatus", mock.Anything, "84acfdfb-e2e8-4a88-b9ed-d466b9f7ef78", rpcuploader.Status_FEATURE_SERVICE_FAILED).Return(nil)

	err := deadletterqueue.Run(context.Background(), suite.c, suite.msg)
	assert.NoError(suite.T(), err)
}

func (suite *DeadLetterWorkerTest) TestSuccessUploadWorkerRunWithUploaderFailure() {
	suite.msg.TopicARN = "imagequeue"
	suite.msg.Message = "{\"upload_id\":\"84acfdfb-e2e8-4a88-b9ed-d466b9f7ef78\",\"output_paths\":[\"s3://ttv-user-pictures-prod/e1cd1506e666a57b-profile_image-150x150.jpeg\",\"s3://ttv-user-pictures-prod/e1cd1506e666a57b-profile_image-300x300.jpeg\"]}"
	suite.uploader.On("UpdateStatus", mock.Anything, "84acfdfb-e2e8-4a88-b9ed-d466b9f7ef78", rpcuploader.Status_FEATURE_SERVICE_FAILED).Return(errors.New("some error"))

	err := deadletterqueue.Run(context.Background(), suite.c, suite.msg)
	assert.NoError(suite.T(), err)
}

func TestDeadLetterWorkerSuite(t *testing.T) {
	suite.Run(t, new(DeadLetterWorkerTest))
}
