package expirecachequeue

import (
	"context"
	"encoding/json"
	"testing"
	"time"

	"github.com/stretchr/testify/mock"

	cachermock "code.justin.tv/web/users-service/internal/clients/cache/rediscacher/mocks"
	"code.justin.tv/web/users-service/internal/worker"
	"code.justin.tv/web/users-service/models"

	"code.justin.tv/web/users-service/internal/worker/snsmodels"
	"github.com/stretchr/testify/assert"
)

func TestExpireCacheMissingCacheKeys(t *testing.T) {

	mockClients := worker.Clients{
		LocalExpirationCacher: nil,
	}
	params := models.SNSExpireCacheEvent{
		Keys:      "",
		Timestamp: time.Now(),
	}
	data, err := json.Marshal(params)
	assert.NoError(t, err)

	message := snsmodels.Message{
		Message:           string(data),
		MessageAttributes: map[string]snsmodels.MessageAttribute{"event": snsmodels.MessageAttribute{Type: "String", Value: "Test Event"}},
		Timestamp:         time.Now(),
	}

	ctx := context.Background()
	err = Run(ctx, mockClients, message)
	assert.EqualError(t, err, "missing cache keys")
}

func TestExpireCache(t *testing.T) {
	ctx := context.Background()

	mockCacher := &cachermock.LocalExpirationCacher{}

	mockClients := worker.Clients{
		LocalExpirationCacher: mockCacher,
	}

	params := models.SNSExpireCacheEvent{
		Keys:      "key1,key2,key3",
		Timestamp: time.Now(),
	}
	data, err := json.Marshal(params)
	assert.NoError(t, err)

	//mockUsers.On("GetUserPropertiesByID", mock.Anything, params.Key, mock.Anything).Return(userProps, nil)
	//mockUsers.On("SetUserProperties", mock.Anything, params.Key, upToUpdate).Return(nil)

	mockCacher.On("ExpireLocalCaches", mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(nil)
	message := snsmodels.Message{
		Message:           string(data),
		MessageAttributes: map[string]snsmodels.MessageAttribute{"event": snsmodels.MessageAttribute{Type: "String", Value: "Test Event"}},
		Timestamp:         time.Now(),
	}

	err = Run(ctx, mockClients, message)
	assert.NoError(t, err)
	mockCacher.AssertCalled(t, "ExpireLocalCaches", mock.Anything, "key1", "key2", "key3")
}
