package snsmodels

import "time"

// Message is a message published from SNS to SQS.
type Message struct {
	MessageID         string                      `json:"MessageId"`
	Message           string                      `json:"Message"`
	Timestamp         time.Time                   `json:"Timestamp"`
	MessageAttributes map[string]MessageAttribute `json:"MessageAttributes"`
	TopicARN          string                      `json:"TopicArn"`
}

// MessageAttribute is structured metadata that accompanies an SQS message.
// source: http://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html
type MessageAttribute struct {
	Type  string `json:"Type"`
	Value string `json:"Value"`
}
