freeStyleJob('web-users-service') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'web/users-service', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    colorizeOutput()
  }

  steps {
    shell 'make test-in-ci'
    saveDeployArtifact 'web/users-service', './artifact'
  }

  publishers {
    reportQuality('web/users-service', '.', '*.out')
  }
}

freeStyleJob('web-users-service-deploy') {
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --short-circuit --repo web/users-service --dir /opt/twitch/users-service'
  }
}

[staging: [
    access_key: "twitch-users-service-dev-tcs-access-key",
    secret_key: "twitch-users-service-dev-tcs-secret-key"
],prod: [
    access_key: "twitch-users-service-prod-tcs-access-key",
    secret_key: "twitch-users-service-prod-tcs-secret-key"
]].each { environment, values ->
  job {
    name "web-users-service-eb-deploy-${environment}"
    using 'TEMPLATE-deploy-aws'
    wrappers {
        credentialsBinding {
          file('COURIERD_PRIVATE_KEY', 'courierd')
          file('AWS_CONFIG_FILE', 'aws_config')
          string 'AWS_ACCESS_KEY', "${values.access_key}"
          string 'AWS_SECRET_KEY', "${values.secret_key}"
        }
    }

    steps {
      downloadDeployArtifact "web/users-service"
      shell 'rm *.manifest*'
      shell "scripts/jenkins_deploy.sh"
    }
  }
}
