package logic

import (
	"testing"
	"time"

	"code.justin.tv/web/users-service/models"
)

type phoneNumberVerifyScenario struct {
	Props *models.PhoneNumberProperties

	Received time.Time
	Code     string

	Failure bool
}

func (s phoneNumberVerifyScenario) Test(t *testing.T) {
	err := verifyPhoneNumberProperties(s.Props, s.Code, s.Received)

	if err == nil && s.Failure {
		t.Fatal("expected failure")
	} else if err != nil && !s.Failure {
		t.Fatal("unexpected failure:", err)
	}
}

func TestPhoneNumberVerify(t *testing.T) {
	for name, scenario := range map[string]phoneNumberVerifyScenario{
		"happy path": {
			Props: &models.PhoneNumberProperties{
				SentAt: time.Now().Add(-30 * time.Minute),
				Code:   "123123",
			},
			Received: time.Now(),
			Code:     "123123",
		},
		"invalid code": {
			Props: &models.PhoneNumberProperties{
				SentAt: time.Now().Add(-30 * time.Minute),
				Code:   "123123",
			},
			Received: time.Now(),
			Code:     "123124",
			Failure:  true,
		},
		"expired code": {
			Props: &models.PhoneNumberProperties{
				SentAt: time.Now().Add(-30 * time.Hour),
				Code:   "123123",
			},
			Received: time.Now(),
			Code:     "123123",
			Failure:  true,
		},
	} {
		t.Run(name, scenario.Test)
	}
}
