package apperror

import "net/http"

type Error struct {
	msg              string
	ValidationFailed bool
	ErrorCode        string
	ShouldLogValue   bool
}

func (e *Error) Error() string {
	return e.msg
}

func (e *Error) Code() string {
	return e.ErrorCode
}

func (e *Error) StatusCode() int {
	if e.ValidationFailed {
		return http.StatusForbidden
	}

	return http.StatusInternalServerError
}

func (e *Error) ShouldLog() bool {
	return e.ShouldLogValue
}

func New(msg string, vf bool, sc string) *Error {
	return &Error{msg: msg, ValidationFailed: vf, ErrorCode: sc}
}
