FROM ubuntu:16.04

RUN apt-get update && apt-get install -y libgeoip-dev && rm -rf /var/lib/apt/lists/*

RUN mkdir -p /usr/bin
COPY ./artifact/users-service /usr/bin/users-service
WORKDIR /usr/bin

ARG STARTUP

# docker only evaluates ARG at build time, so this intermediate script captures it value
# so it can be used at runtime.
RUN echo "#!/bin/bash\n/usr/bin/users-service $STARTUP" > /usr/bin/executable && chmod 755 /usr/bin/executable

EXPOSE 8000
ENTRYPOINT ["/usr/bin/executable"]
