resource "aws_sns_topic" "pagerduty_alarm" {
  name = "pagerduty_users-service"
}

module "internal_app_elb_alarms" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/elb/alarms"
  elb_name = "${aws_elb.internal_app_elb.name}"
  action_arns = "${aws_sns_topic.pagerduty_alarm.arn}"
  backend_conn_error_threshold = "15000"
  unhealthy_hosts_evaluation_periods = "60"
  elb_http_4xx_threshold = "2000000"
  elb_elb_5xx_evaluation_periods = "60"
  elb_elb_5xx_threshold = "10000"
  elb_http_5xx_evaluation_periods = "30"
  elb_http_5xx_threshold = "10000"
}

resource "aws_cloudwatch_metric_alarm" "app-cpu" {
  alarm_name = "${var.name}_asg_cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "60"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "50"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "app-status" {
  alarm_name = "${var.name}_asg_status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-cpu" {
  alarm_name = "${var.name}_canary_asg_cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "60"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "50"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-status" {
  alarm_name = "${var.name}_canary_asg_status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}
