# Service name used for AWS tagging among other things
variable "name" {}

# Team email alias
variable "owner" {}

# Project name, usually git repo. ex. dta/twitch-create-service
variable "project" {}

# Service environment
variable "environment" {}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  default = "users-service"
}

# ARN for https certificate to use
variable "https_certificate" {}

# Security group postfix to use for instances and ELB
variable "security_group" {
}

# Amount of diskspace allocated to the root drive. (GB)
variable "root_volume_size" {
  default = 256
}

# EC2 Instance Image
variable "ami" {
  default = "ami-dd11f3bd"
}

# EC2 Instance Type
variable "instance_type" {
  default = "c4.large"
}

# Largest a service cluster will grow to
variable "max_size" {
  default = 0
}

# Smallest a service cluster will shrink down to
variable "min_size" {
  default = 0
}

# Number of canary instances
variable "canary_size" {
  default = 0
}

# DNS safe service name
variable "hostname" {}

# Domain name 
variable domain {
	default = {
		"production" = "prod.us-west2.justin.tv"
		"staging" = "dev.us-west2.justin.tv"
	}
}

variable "target_aws_account" {
  default = {
    "production" = "twitch-web-aws"
    "staging" = "twitch-web-dev"
  }
}

# Service role for controlling access to other AWS services
variable "iam_role_id" {}
variable "iam_role_arn" {}
