variable "profile" {}
variable "region" {}

provider "aws" {
  region  = "${var.region}"
  profile = "${var.profile}"
}

variable "vpc_id" {}
variable "owner" {}

variable subnets {
  # This came from https://aws-vpc-api.internal.justin.tv/region/list-html/
  default = ["172.31.0.0/16", "10.164.0.0/15", "10.174.0.0/15", "10.170.0.0/15", "10.166.0.0/15", "10.168.0.0/15", "10.188.0.0/15", "10.172.0.0/15", "10.190.0.0/15", "10.178.0.0/15", "10.176.0.0/15", "10.180.0.0/15", "10.182.0.0/15", "10.160.0.0/14", "10.184.0.0/15", "10.186.0.0/15", "10.192.0.0/12"]
}

resource "aws_security_group" "aws_only_subnets" {
  name        = "aws_only_subnets"
  description = "allow all traffic between twitchs AWS IP space"
  vpc_id      = "${var.vpc_id}"

  tags {
    Name  = "aws_only_subnets"
    Owner = "${var.owner}"
  }

  ingress {
    from_port   = 0
    to_port     = 0
    protocol    = -1
    cidr_blocks = ["${var.subnets}"]
    self        = true
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
}

output "sg" {
  value = "${aws_security_group.aws_only_subnets.id}"
}
