// Run beanstalk module
module "beanstalk" {
  source                  = "../beanstalk"
  environment             = "${var.environment}"
  new_account_environment = "${var.new_account_environment}"
  aws_region              = "${var.aws_region}"
  iam_role_id             = "${aws_iam_role.users_service.id}"
  iam_role_arn            = "${aws_iam_role.users_service.arn}"
  asg_min_size            = "${var.asg_min_size}"
  asg_max_size            = "${var.asg_max_size}"
  deploy_batch_size_type  = "${var.deploy_batch_size_type}"
  deploy_batch_size       = "${var.deploy_batch_size}"
  deploy_timeout          = "${var.deploy_timeout}"
  override_security_group = "${var.override_security_group}"
  instance_type           = "${var.instance_type}"
  environment_suffix      = "${var.environment_suffix}"
  platform_version        = "${var.platform_version}"
}

output "canary_name" {
  value = "${module.beanstalk.canary_name}"
}
