resource "aws_iam_role" "users_service" {
  name = "users-service-${var.aws_region}"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

data "aws_iam_policy_document" "users_service_cross_account" {
  statement {
    effect = "Allow"

    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${data.terraform_remote_state.users-service.iam_role_arn}",
      "${var.kinesis_stream_iam}",
    ]
  }
}

resource "aws_iam_role_policy" "users_service_cross_account" {
  name   = "users_service_cross_account"
  policy = "${data.aws_iam_policy_document.users_service_cross_account.json}"

  // Get this from beanstalk module run
  role = "${aws_iam_role.users_service.id}"
}

data "aws_iam_policy_document" "users_service_cross_account_sqs" {
  statement {
    effect = "Allow"

    actions = [
      "sqs:*",
    ]

    resources = [
      "arn:aws:sqs:*:${var.old_account_number}:*",
    ]
  }
}

resource "aws_iam_role_policy" "users_service_cross_account_sqs" {
  name   = "users_service_cross_account_sqs"
  policy = "${data.aws_iam_policy_document.users_service_cross_account_sqs.json}"

  // Get this from beanstalk module run
  role = "${aws_iam_role.users_service.id}"
}
