data "aws_iam_policy_document" "users_service_sandstorm" {
  statement {
    effect = "Allow"

    actions = [
      "sts:AssumeRole",
    ]

    resources = ["arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-${var.environment}-${var.aws_region}"]
  }
}

resource "aws_iam_role_policy" "users_service_sandstorm" {
  name   = "users_service_sandstorm"
  policy = "${data.aws_iam_policy_document.users_service_sandstorm.json}"
  role   = "${var.iam_role_id}"
}
