resource "aws_elasticache_replication_group" "cache" {
  replication_group_id = "${var.name}-cache"
  replication_group_description = "Users Service Redis Cluster"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  parameter_group_name = "${var.parameter_group_name}"
  node_type = "${var.node_type}"
  port = 6379
  subnet_group_name = "${aws_elasticache_subnet_group.cache.name}"
  security_group_ids = ["${aws_security_group.cache.id}"]
  automatic_failover_enabled = true
  apply_immediately = true
  cluster_mode {
    replicas_per_node_group     = "${var.replicas_per_node_group}"
    num_node_groups             = "${var.num_node_groups}"
  }
}

resource "aws_elasticache_subnet_group" "cache" {
  name = "${var.name}-${var.environment}-cache-subnet-group"
  description = "Users Service ${var.environment} subnet group for cache"
  subnet_ids = ["${data.terraform_remote_state.twitch_target_aws_account.data_a}",
    "${data.terraform_remote_state.twitch_target_aws_account.data_b}",
    "${data.terraform_remote_state.twitch_target_aws_account.data_c}"]
}

resource "aws_security_group" "cache" {
  name = "${var.name}-${var.environment}-cache-security-group"
  description = "Users Service ${var.environment} security group for cache"
  vpc_id = "${data.terraform_remote_state.twitch_target_aws_account.vpc_id}"

  ingress {
    from_port = 6379
    to_port = 6379
    protocol = "tcp"
    security_groups = ["${var.security_group}"]
  }
}