resource "aws_db_instance" "users-db-master" {
  allocated_storage = "${var.allocated_storage}"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  identifier = "${var.name}-${var.environment}-master"
  instance_class = "${var.instance_type}"
  storage_type = "${var.storage_type}"
  iops = "${var.iops}"
  username = "${var.username}"
  password = "${var.password}"
  port = "${var.port}"
  db_subnet_group_name = "${aws_db_subnet_group.users-subnet.name}"
  multi_az = "${var.multi_az}"
  publicly_accessible = "${var.publicly_accessible}"
  backup_retention_period = "${var.backup_retention_period}"
  vpc_security_group_ids = ["${data.terraform_remote_state.systems.twitch_subnets_sg_id[var.aws_region]}"]

  snapshot_identifier = "${var.snapshot_identifier}"
}

resource "aws_db_instance" "users-db-replica-1" {
  replicate_source_db = "${aws_db_instance.users-db-master.identifier}"
  allocated_storage = "${var.allocated_storage}"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  identifier = "${var.name}-${var.environment}-replica-1"
  instance_class = "${var.instance_type}"
  storage_type = "${var.storage_type}"
  iops = "${var.iops}"
  username = "${var.username}"
  password = "${var.password}"
  port = "${var.replica_port}"
  publicly_accessible = "${var.publicly_accessible}"
  vpc_security_group_ids = ["${data.terraform_remote_state.systems.twitch_subnets_sg_id[var.aws_region]}"]
}

resource "aws_db_subnet_group" "users-subnet" {
  name = "${var.name}-${var.environment}-subnet"
  description = "Users service db subnets"
  subnet_ids = ["${data.terraform_remote_state.systems.private_subnets[var.aws_region]}"]

  tags {
  	"Owner" = "core-user@justin.tv"
  }
}

resource "aws_route53_record" "master-dns" {
  provider = "aws.twitch-aws"

  zone_id = "${module.base.r53}"
  name = "master-users-db-new.${var.environment}.us-west2.justin.tv"
  type = "CNAME"
  ttl = "300"
  records = ["${aws_db_instance.users-db-master.address}"]
}

resource "aws_route53_record" "replica-dns" {
  provider = "aws.twitch-aws"
  zone_id = "${module.base.r53}"
  name = "replica-users-db-new.${var.environment}.us-west2.justin.tv"
  type = "CNAME"
  ttl = "300"
  records = ["${aws_db_instance.users-db-replica-1.address}"]
}
