resource "aws_elasticache_replication_group" "cache-primary" {
  replication_group_id = "us-primary-cache"
  replication_group_description = "Users Service Primary Redis Cluster"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  parameter_group_name = "${var.parameter_group_name}"
  node_type = "${var.node_type}"
  port = 6379
  subnet_group_name = "${aws_elasticache_subnet_group.cache.name}"
  security_group_ids = ["${data.terraform_remote_state.systems.twitch_subnets_sg_id[var.aws_region]}"]
  automatic_failover_enabled = true
  apply_immediately = true
  cluster_mode {
    replicas_per_node_group     = "${var.replicas_per_node_group}"
    num_node_groups             = "${var.num_node_groups}"
  }
}

resource "aws_elasticache_replication_group" "cache-backup" {
  replication_group_id = "us-backup-cache"
  replication_group_description = "Users Service Backup Redis Cluster"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  parameter_group_name = "${var.parameter_group_name}"
  node_type = "${var.node_type}"
  port = 6379
  subnet_group_name = "${aws_elasticache_subnet_group.cache.name}"
  security_group_ids = ["${data.terraform_remote_state.systems.twitch_subnets_sg_id[var.aws_region]}"]
  automatic_failover_enabled = true
  apply_immediately = true
  cluster_mode {
    replicas_per_node_group     = "${var.replicas_per_node_group}"
    num_node_groups             = "${var.num_node_groups}"
  }
}

resource "aws_elasticache_subnet_group" "cache" {
  name = "${var.name}-${var.environment}-cache-subnet-group"
  description = "Users Service ${var.environment} subnet group for cache"
  subnet_ids = ["${data.terraform_remote_state.systems.private_subnets[var.aws_region]}"]
}

