data "terraform_remote_state" "twitch_target_aws_account" {
  backend = "s3"
  config {
    bucket = "${lookup(var.target_aws_account, var.environment)}"
    region = "us-west-2"
    key = "tfstate/web/terraform/accounts/${lookup(var.target_aws_account, var.environment)}"
  }
}

# twitch-users-service-${var.new_account_environment} systems state
data "terraform_remote_state" "systems" {
  backend = "s3"
  config {
    bucket = "twitch-users-service-${lookup(var.new_account_environment, var.environment)}"
    profile = "twitch-users-service-${lookup(var.new_account_environment, var.environment)}"
    key = "tfstate/systems/terraform/${lookup(var.new_account_environment, var.environment)}/twitch-users-service-${lookup(var.new_account_environment, var.environment)}/terraform.tfstate"
  }
}