// Used to gunzip payload
var zlib = require('zlib');
// Used to create tcp client to send to logstash
var net = require('net');
// Newline to ensure JSONL is sent to logstash
var endOfLine = require('os').EOL;

const logstashAddr = process.env.LOGSTASH_ADDR
const logstashPort = parseInt(process.env.LOGSTASH_PORT, 10)
const service = process.env.SERVICE
const environment = process.env.ENVIRONMENT
const region = process.env.REGION

exports.handler = function(input, context) {
    var payload = new Buffer(input.awslogs.data, 'base64');
    zlib.gunzip(payload, function(e, result) {
        if (e) {
            context.fail(e);
        } else {
            result = JSON.parse(result.toString('ascii'));
            context.succeed();

            handle(result)
        }
    });
};

function handle(result) {
    // tcp client to talk to logstash
    var client = new net.Socket()

    if (!client.connect(logstashPort, logstashAddr)) {
        context.fail("failed to connect to server")
    }

    var envPieces = result.logGroup.split("/")
    var environment = ""
    var logfile = ""

    if (envPieces.length >= 4) {
        environment = envPieces[3];

        logfile = envPieces.splice(4).join("/")
    }

    for(var i = 0; i < result.logEvents.length; i++) {
        var logEvent = result.logEvents[i]
        if (logfile == "var/log/nginx/access.log") {
            // Ignore /var/log/nginx/access.log 200's, too noisy
            // Example log message: 10.202.70.135 - - [31/Oct/2017:18:02:05 +0000] "GET /users/119072418?return_id_as_string=true HTTP/1.1" 200 636 "-" "Go-http-client/1.1"
            statusCode = logEvent.message.split('\"')[2].split(" ")[1]

            if (statusCode - 200 < 100) {
                // Ignore status codes that are less than 200
                continue
            }
        }

        var message = {
            "message": logEvent.message,
            "@timestamp": new Date(logEvent.timestamp).toISOString(),
            "logstream": result.logStream,
            "loggroup": result.logGroup,
            "beanstalkenv": environment,
            "service": service,
            "environment": environment,
            "region": region
        }
        client.write(JSON.stringify(message)+endOfLine)
    }
}
