variable "logstash_addr" {
  default = ""
}

variable "logstash_port" {
  default = ""
}

variable "service" {
  default = "users-service"
}

variable "environment" {
  default = "staging"
}

variable "region" {
  default = ""
}

variable "profile" {
  default = ""
}

variable "source_account" {
  default = ""
}

variable "source_arn" {
  default = ""
}

variable "log_groups" {
  type = "list"
}

variable "subnet_ids" {
  type = "list"
}

variable "security_group_ids" {
  default = ""
}

provider "aws" {
  profile = "${var.profile}"
  region  = "${var.region}"
}

// Create role
resource "aws_iam_role" "logstash_bridge" {
  name = "${var.region}-${var.service}-logstash_bridge"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

// Attach policies here
resource "aws_iam_role_policy_attachment" "execute" {
  role       = "${aws_iam_role.logstash_bridge.name}"
  policy_arn = "arn:aws:iam::aws:policy/AWSLambdaExecute"
}

resource "aws_iam_role_policy_attachment" "vpc-access" {
  role       = "${aws_iam_role.logstash_bridge.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole"
}

// Create lambda
resource "aws_lambda_function" "logstash_bridge" {
  // This has to be manually zipped: pushd ../../../modules/logging/files; zip main.zip main.js; popd
  filename         = "${path.module}/files/main.zip"
  function_name    = "${var.environment}-${var.service}-logstash_bridge"
  role             = "${aws_iam_role.logstash_bridge.arn}"
  handler          = "main.handler"
  source_code_hash = "${base64sha256(file("${path.module}/files/main.zip"))}"
  runtime          = "nodejs4.3"

  environment {
    variables = {
      LOGSTASH_ADDR = "${var.logstash_addr}"
      LOGSTASH_PORT = "${var.logstash_port}"
      SERVICE       = "${var.service}"
      ENVIRONMENT   = "${var.environment}"
      REGION        = "${var.region}"
    }
  }

  vpc_config {
    subnet_ids         = ["${var.subnet_ids}"]
    security_group_ids = ["${var.security_group_ids}"]
  }
}

// Add permission to invoke function
resource "aws_lambda_permission" "allow_cloudwatch_logs" {
  statement_id   = "AllowExecutionFromCloudWatch"
  action         = "lambda:InvokeFunction"
  function_name  = "${aws_lambda_function.logstash_bridge.function_name}"
  principal      = "logs.${var.region}.amazonaws.com"
  source_account = "${var.source_account}"
  source_arn     = "${var.source_arn}"
}

// Add subscription for each group
resource "aws_cloudwatch_log_subscription_filter" "filters" {
  name            = "${element(var.log_groups, count.index)}"
  log_group_name  = "${element(var.log_groups, count.index)}"
  filter_pattern  = ""
  destination_arn = "${aws_lambda_function.logstash_bridge.arn}"

  count = "${length(var.log_groups)}"
}
