variable "new_account_environment" {}

# systems network state
data "terraform_remote_state" "systems" {
  backend = "s3"
  config {
    bucket = "twitch-users-service-${var.new_account_environment}"
    profile = "twitch-users-service-${var.new_account_environment}"
    key = "tfstate/systems/terraform/${var.new_account_environment}/twitch-users-service-${var.new_account_environment}/terraform.tfstate"
  }
}

output "private_subnets" {
  value = "${map(
    "us-west-2", "${data.terraform_remote_state.systems.private_subnets}",
    "us-east-1", "${data.terraform_remote_state.systems.us-east-1_private_subnets}",
  )}"
}

output "public_subnets" {
  value = "${map(
    "us-west-2", "${data.terraform_remote_state.systems.public_subnets}",
    "us-east-1", "${data.terraform_remote_state.systems.us-east-1_public_subnets}",
  )}"
}

output "twitch_subnets_sg_id" {
  value = "${map(
    "us-west-2", "${data.terraform_remote_state.systems.twitch_subnets_sg_id}",
    "us-east-1", "${data.terraform_remote_state.systems.us-east-1_twitch_subnets_sg_id}",
  )}"
}

output "vpc_id" {
  value = "${map(
    "us-west-2", "${data.terraform_remote_state.systems.vpc_id}",
    "us-east-1", "${data.terraform_remote_state.systems.us-east-1_vpc_id}",
  )}"
}
