module "rds_buddy" {
    source = "git::git+ssh://git@git-aws.internal.justin.tv/d8a/provisioning.git//rds-buddy/lib/rds-buddy.20160926"

    pagerduty_key = "${var.pagerduty_key}"
    pagerduty_service = "${var.pagerduty_service}"

    subnet_id = "${data.terraform_remote_state.twitch_target_aws_account.service_a},${data.terraform_remote_state.twitch_target_aws_account.service_b},${data.terraform_remote_state.twitch_target_aws_account.service_c}"
    security_groups = "${data.terraform_remote_state.twitch_target_aws_account.twitch_subnets_sg}"

    team = "${var.team}"
    twitch_environment = "${var.environment}"
    aws_account = "${lookup(var.target_aws_account, var.environment)}"
    aws_profile = "${var.aws_profile}"

    sandstorm_role_arn = "${var.sandstorm_role_arn}"

    raise_instance = "${var.raise_instance}"

    owner_tag = "${var.team} <${var.team_email}>"
    project_tag = "web/users-service"
}

module "notifications_route53" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "${var.aws_profile}"
  topic_name = "rds-buddy_r53_${var.team}_${var.environment}"
  asg_name = "${module.rds_buddy.asg_name}"
  lambda_arn = "arn:aws:lambda:us-west-2:${data.aws_caller_identity.current.account_id}:function:asg_route53_update"
}

data "aws_caller_identity" "current" {}
