# This policy defines the AWS accounts that may publish to this topic.
resource "aws_sns_topic_policy" "user_deletion_events_policy" {
  arn = "${lookup(var.user_deletion_sns, var.environment)}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "notification_user_destroyed_legacy_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::603200399373:root",
          "${lookup(var.devsuccess_iam_arns, var.environment)}"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:ListSubscriptionsByTopic",
        "SNS:Receive"
      ],
      "Resource": [
        "${lookup(var.user_deletion_sns, var.environment)}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${lookup(var.user_deletion_sns, var.environment)}"
      ]
    }
  ]
}
EOF
}
