provider "aws" {
  profile = "${var.aws_profile}"
  region = "${var.aws_region}"
}

resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com",
        "AWS": "${lookup(var.cross_account_iam_arn, "${var.environment}.${var.aws_region}")}"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "app" {
  name = "${var.iam_role_name}"
  role = "${aws_iam_role.app.id}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Resource": "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-${var.environment}"
    },
    {
      "Sid": "Stmt1473817796000",
      "Effect": "Allow",
      "Action": "s3:GetObject",
      "Resource": "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"
    },
    {
      "Effect": "Allow",
      "NotAction": "kinesis:DeleteStream",
      "Resource": "${var.kinesis_mutation_stream}"
    },
    {
      "Effect": "Allow",
      "Action": "sns:Publish",
      "Resource": [
        "${lookup(var.user_moderation_sns, "var.environment.${var.aws_region}", lookup(var.user_moderation_sns, var.environment))}",
        "${lookup(var.user_rename_sns, "var.environment.${var.aws_region}", lookup(var.user_rename_sns, var.environment))}",
        "${lookup(var.user_mutation_sns, "var.environment.${var.aws_region}", lookup(var.user_mutation_sns, var.environment))}",
        "${lookup(var.channel_mutation_sns, "var.environment.${var.aws_region}", lookup(var.channel_mutation_sns, var.environment))}",
        "${lookup(var.user_soft_delete_sns, "var.environment.${var.aws_region}", lookup(var.user_soft_delete_sns, var.environment))}",
        "${lookup(var.user_undelete_sns, "var.environment.${var.aws_region}", lookup(var.user_undelete_sns, var.environment))}",
        "${lookup(var.cache_expiration_sns, "${var.environment}.${var.aws_region}")}",
        "${lookup(var.user_creation_sns, "var.environment.${var.aws_region}", lookup(var.user_creation_sns, var.environment))}",
        "${lookup(var.user_deletion_sns, "var.environment.${var.aws_region}", lookup(var.user_deletion_sns, var.environment))}",
        "${lookup(var.pushy_dispatch_sns, "var.environment.${var.aws_region}", lookup(var.pushy_dispatch_sns, var.environment))}"
      ]
    },
    {
      "Effect": "Allow",
      "Action": "s3:*",
      "Resource": [
          "arn:aws:s3:::ttv-user-pictures-prod",
          "arn:aws:s3:::ttv-user-pictures-prod/*"
      ]
    },
    {
      "Effect": "Allow",
      "Action": "xray:*",
      "Resource": "*"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "sqs" {
  name = "${var.iam_role_name}-sqs"
  role = "${aws_iam_role.app.id}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
      {
          "Effect": "Allow",
          "Action": [
              "sqs:ChangeMessageVisibility",
              "sqs:CreateQueue",
              "sqs:DeleteMessage",
              "sqs:GetQueueAttributes",
              "sqs:GetQueueUrl",
              "sqs:ReceiveMessage"
          ],
          "Resource": [
              "${aws_sqs_queue.email_verified_queue.arn}",
              "${aws_sqs_queue.cache_expiration_queue.arn}",
              "${aws_sqs_queue.image_upload_queue.arn}",
              "${aws_sqs_queue.dead_letter_queue.arn}"
          ]
      }
  ]
}
  EOF
}
