resource "aws_sns_topic" "user_moderation_events" {
  name = "user_moderation_events"
}

resource "aws_sns_topic" "user_creation_events" {
  name = "user_creation_events"
}

resource "aws_sns_topic" "user_deletion_events" {
  name = "user_deletion_events"
}

resource "aws_sns_topic" "user_rename_events" {
  name = "user_rename_events"
}

resource "aws_sns_topic" "user_mutation_events" {
  name = "user_mutation_events"
}

resource "aws_sns_topic" "channel_mutation_events" {
  name = "channel_mutation_events"
}

resource "aws_sns_topic" "user_soft_delete_events" {
  name = "user_soft_delete_events"
}

resource "aws_sns_topic" "user_undelete_events" {
  name = "user_undelete_events"
}

resource "aws_sns_topic" "user_image_upload_events" {
  name = "user_image_upload_events"
}

resource "aws_sns_topic" "cache_expiration_events" {
  name = "cache_expiration_events"
}

# This policy defines the AWS accounts that may subscribe or publish to this topic.
resource "aws_sns_topic_policy" "user_moderation_events_policy" {
  arn = "${aws_sns_topic.user_moderation_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_moderation_events_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::603200399373:root",
          "${lookup(var.vinyl_iam_arn, var.environment)}",
          "${lookup(var.subscriptions_iam_arn, var.environment)}"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:Receive",
        "SNS:ListSubscriptionsByTopic"
      ],
      "Resource": [
        "${aws_sns_topic.user_moderation_events.arn}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_moderation_events.arn}"
      ]
    }        
  ]
}
EOF
}

# This policy defines the AWS accounts that may subscribe or publish to this topic.
resource "aws_sns_topic_policy" "user_mutation_events_policy" {
  arn = "${aws_sns_topic.user_mutation_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_mutatopm_events_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::924637445623:root"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:Receive"
      ],
      "Resource": [
        "${aws_sns_topic.user_mutation_events.arn}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_mutation_events.arn}"
      ]
    }        
  ]
}
EOF
}

# This policy defines the AWS accounts that may subscribe or publish to this topic.
resource "aws_sns_topic_policy" "user_rename_events_policy" {
  arn = "${aws_sns_topic.user_rename_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_rename_events_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::994136867826:root",
          "arn:aws:iam::709492852051:root",
          "arn:aws:iam::603200399373:root"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:ListSubscriptionsByTopic",
        "SNS:Receive"
      ],
      "Resource": [
        "${aws_sns_topic.user_rename_events.arn}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_rename_events.arn}"
      ]
    }        
  ]
}
EOF
}

# This policy defines the AWS accounts that may subscribe or publish to this topic.
resource "aws_sns_topic_policy" "channel_mutation_events_policy" {
  arn = "${aws_sns_topic.channel_mutation_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "channel_mutation_events_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::989470033077:root"
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:Receive"
      ],
      "Resource": [
        "${aws_sns_topic.channel_mutation_events.arn}"
      ]
    },
    {
      "Sid": "lambda-access",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::541623737611:root",
          "arn:aws:iam::994136867826:root"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:ListSubscriptionsByTopic",
        "SNS:Receive"
      ],
      "Resource": [
        "${aws_sns_topic.channel_mutation_events.arn}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.channel_mutation_events.arn}"
      ]
    }    
  ]
}
EOF
}

# This policy defines the AWS accounts that may publish to this topic.
resource "aws_sns_topic_policy" "cache_expiration_events_policy" {
  arn = "${aws_sns_topic.cache_expiration_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "cache_expiration_events_policy",
  "Statement":[
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.cache_expiration_events.arn}"
      ]
    }
    
  ]
}
EOF
}

# This policy defines the AWS accounts that may publish to this topic.
resource "aws_sns_topic_policy" "user_creation_events_policy" {
  arn = "${aws_sns_topic.user_creation_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_creation_events_policy",
  "Statement":[
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_creation_events.arn}"
      ]
    }
    
  ]
}
EOF
}

# This policy defines the AWS accounts that may publish to this topic.
resource "aws_sns_topic_policy" "user_deletion_events_policy" {
  arn = "${aws_sns_topic.user_deletion_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_deletion_events_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::603200399373:root",
          "${lookup(var.devsuccess_iam_arns, var.environment)}"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:ListSubscriptionsByTopic",
        "SNS:Receive"
      ],
      "Resource": [
        "${aws_sns_topic.user_deletion_events.arn}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_deletion_events.arn}"
      ]
    }
    
  ]
}
EOF
}

# This policy defines the AWS accounts that may publish to this topic.
resource "aws_sns_topic_policy" "user_soft_delete_events_policy" {
  arn = "${aws_sns_topic.user_soft_delete_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_soft_delete_events_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::603200399373:root"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:ListSubscriptionsByTopic",
        "SNS:Receive"
      ],
      "Resource": [
        "${aws_sns_topic.user_soft_delete_events.arn}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_soft_delete_events.arn}"
      ]
    }
    
  ]
}
EOF
}

# This policy defines the AWS accounts that may publish to this topic.
resource "aws_sns_topic_policy" "user_undelete_events_policy" {
  arn = "${aws_sns_topic.user_undelete_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_undelete_events_policy",
  "Statement":[
    {
      "Sid": "AllowSubscriptionsFromOtherTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::603200399373:root"
        ]
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:ListSubscriptionsByTopic",
        "SNS:Receive"
      ],
      "Resource": [
        "${aws_sns_topic.user_undelete_events.arn}"
      ]
    },
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_undelete_events.arn}"
      ]
    }
    
  ]
}
EOF
}

# This policy defines the AWS accounts that may publish to this topic.
resource "aws_sns_topic_policy" "user_image_upload_events_policy" {
  arn = "${aws_sns_topic.user_image_upload_events.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "user_image_upload_events_policy",
  "Statement":[
    {
      "Sid": "AllowPublishFromCrossRegionAccount",
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "${lookup(var.user_service_publish_iam_arn, "${var.environment}.${var.aws_region}")}"
        ]
      },
      "Action": [
        "SNS:Publish"
      ],
      "Resource": [
        "${aws_sns_topic.user_image_upload_events.arn}"
      ]
    }
    
  ]
}
EOF
}
