# Service name used for AWS tagging among other things
variable "name" {}

# Team email alias
variable "owner" {}

# Project name, usually git repo. ex. dta/twitch-create-service
variable "project" {}

# Service environment
variable "environment" {}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  default = "users-service"
}

# ARN for kinesis stream that receives user mutations
variable "kinesis_mutation_stream" {}

# AWS region to create resources in
variable "aws_region" {}

# AWS profile to use for aws resources
variable "aws_profile" {}

variable "user_creation_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:notification-user-created"
    "staging" = "arn:aws:sns:us-west-2:465369119046:notification-user-created"
  }
}

variable "email_validation_success_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:523543649671:email-validation-success"
    "staging" = "arn:aws:sns:us-west-2:510557735000:email-validation-success"
  }
}

variable "users_service_iam_arns" {
  default = {
    "production" = "arn:aws:iam::641044725657:role/users-service,arn:aws:iam::931896176507:root"
    "staging" = "arn:aws:iam::465369119046:role/users-service,arn:aws:iam::404788901388:root"
  }
}

variable "user_deletion_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:notification-user-destroyed"
    "staging" = "arn:aws:sns:us-west-2:465369119046:notification-user-destroyed"
  }
}

variable "pushy_dispatch_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:603200399373:pushy_production_dispatch"
    "staging" = "arn:aws:sns:us-west-2:603200399373:pushy_darklaunch_dispatch"
  }
}

variable "cache_expiration_sns" {
  default = {
    "production.us-east-1" = "arn:aws:sns:us-west-2:641044725657:cache_expiration_events"
    "production.us-west-2" = "arn:aws:sns:us-east-1:931896176507:cache_expiration_events"
    "staging.us-east-1" = "arn:aws:sns:us-west-2:465369119046:cache_expiration_events"
    "staging.us-west-2" = "arn:aws:sns:us-east-1:404788901388:cache_expiration_events"
  }
}

variable "user_moderation_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:user_moderation_events"
    "staging" = "arn:aws:sns:us-west-2:465369119046:user_moderation_events"
  }
}

variable "user_rename_sns" {
    default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:user_rename_events"
    "staging" = "arn:aws:sns:us-west-2:465369119046:user_rename_events"
  }
}

variable "user_mutation_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:user_mutation_events"
    "staging" = "arn:aws:sns:us-west-2:465369119046:user_mutation_events"
  }
}

variable "channel_mutation_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:channel_mutation_events"
    "staging" = "arn:aws:sns:us-west-2:465369119046:channel_mutation_events"
  }  
}

variable "user_soft_delete_sns" {
   default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:user_soft_delete_events"
    "staging" = "arn:aws:sns:us-west-2:465369119046:user_soft_delete_events"
  }
}

variable "user_undelete_sns" {
  default = {
    "production" = "arn:aws:sns:us-west-2:641044725657:user_undelete_events"
    "staging" = "arn:aws:sns:us-west-2:465369119046:user_undelete_events"
  }
}

# Cross account arn to grant assume role permission to (for our new accounts)
variable "cross_account_iam_arn" {
  default {
      "production.us-west-2" = "arn:aws:iam::931896176507:root"
      "production.us-east-1" = "arn:aws:iam::641044725657:root"
      "staging.us-west-2" = "arn:aws:iam::404788901388:root"
      "staging.us-east-1" = "arn:aws:iam::465369119046:root"
  }
}

variable "vinyl_iam_arn" {
  default = {
    "production" = "arn:aws:iam::134912696936:root"
    "staging" = "arn:aws:iam::134912696936:user/cdym"
  }
}

variable "subscriptions_iam_arn" {
  default = {
    "production" = "arn:aws:iam::522398581884:root"
    "staging" = "arn:aws:iam::958836777662:root"
  }
}

variable "user_service_publish_iam_arn" {
    default = {
      "production.us-west-2" = "arn:aws:iam::931896176507:root"
      "production.us-east-1" = "arn:aws:iam::641044725657:root"
      "staging.us-west-2" = "arn:aws:iam::404788901388:root"
      "staging.us-east-1" = "arn:aws:iam::465369119046:root"
  }
}

variable "devsuccess_iam_arns" {
  default = {
    "production" = "arn:aws:iam::523543649671:root"
    "staging" = "arn:aws:iam::510557735000:root"
  }
}
