module "elasticache" {
  source = "../../../modules/dualcache"
  node_type = "cache.r4.2xlarge"
  environment = "production"
  engine = "redis"
  security_group = "${module.elasticache.twitch_subnets_sg}"
  num_node_groups = 9
  replicas_per_node_group = 5
  aws_region = "us-east-1"
}

terraform {
  backend "s3" {
    bucket = "twitch-users-service-prod"
    key    = "tfstate/web/users-service/terraform/production/us-east-1/cache"
    region = "us-west-2"
    profile = "twitch-users-service-prod"
  }
}

