provider "aws" {
  region = "us-east-1"
}

module "kinesis" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//services/kinesis/modules/web-kinesis"
  shard_count = 1
  retention_period = 24
}

module "users-service" {
  source = "../../modules/users-service"
  name = "users-service"
  owner = "core-user@justin.tv"
  project = "web/users-service"
  environment = "production"
  iam_role_name = "users-service-us-east-1"
  kinesis_mutation_stream = "${module.kinesis.arn_user_mutations}"
  aws_region = "us-east-1"
  aws_profile = "twitch-users-service-prod"
}

output "iam_role_id" {
  value = "${module.users-service.iam_role_id}"
}

output "iam_role_arn" {
  value = "${module.users-service.iam_role_arn}"
}

terraform {
  backend "s3" {
    bucket = "twitch-users-service-prod"
    key    = "tfstate/web/users-service/terraform/production/us-east-1"
    region = "us-west-2"
    profile = "twitch-users-service-prod"
  }
}
