terraform {
  backend "s3" {
    bucket  = "twitch-users-service-prod"
    key     = "tfstate/web/users-service/terraform/production/us-west-2/alarms"
    region  = "us-west-2"
    profile = "twitch-users-service-prod"
  }
}

variable "region" {
  default = "us-west-2"
}

variable "profile" {
  default = "twitch-users-service-prod"
}

module "alerts" {
  source      = "../../../modules/alarms"
  aws_region  = "${var.region}"
  aws_profile = "${var.profile}"
}

output "arn" {
  value = "${module.alerts.arn}"
}

provider "aws" {
  region  = "${var.region}"
  profile = "${var.profile}"
}

resource "aws_sns_topic_subscription" "pagerduty_subscription" {
  topic_arn              = "${module.alerts.arn}"
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = "https://events.pagerduty.com/integration/8628bd4dd1bb4f888d9df65ad65e0cc6/enqueue"
}
