terraform {
  backend "s3" {
    bucket  = "twitch-users-service-prod"
    key     = "tfstate/web/users-service/terraform/production/us-west-2/aws_subnets_only"
    region  = "us-west-2"
    profile = "twitch-users-service-prod"
  }
}

# twitch-users-service-prod systems state
data "terraform_remote_state" "systems" {
  backend = "s3"

  config {
    bucket  = "twitch-users-service-prod"
    profile = "twitch-users-service-prod"
    key     = "tfstate/systems/terraform/prod/twitch-users-service-prod/terraform.tfstate"
    region  = "us-west-2"
  }
}

variable "region" {
  default = "us-west-2"
}

variable "profile" {
  default = "twitch-users-service-prod"
}

module "aws_subnets_only" {
  source  = "../../../modules/aws_subnets_only"
  region  = "${var.region}"
  profile = "${var.profile}"
  owner   = "core-user@justin.tv"
  vpc_id  = "${lookup(data.terraform_remote_state.systems.vpc_id, var.region)}"
}

output "sg" {
  value = "${module.aws_subnets_only.sg}"
}
