terraform {
  backend "s3" {
    bucket  = "twitch-users-service-prod"
    key     = "tfstate/web/users-service/terraform/production/us-west-2/beanstalk"
    region  = "us-west-2"
    profile = "twitch-users-service-prod"
  }
}

variable "environment" {
  default = "production"
}

variable "profile" {
  default = "twitch-users-service-prod"
}

variable "region" {
  default = "us-west-2"
}

data "terraform_remote_state" "aws_subnets_only" {
  backend = "s3"

  config {
    bucket  = "${var.profile}"
    profile = "${var.profile}"
    region  = "us-west-2"
    key     = "tfstate/web/users-service/terraform/${var.environment}/${var.region}/aws_subnets_only"
  }
}

module "beanstalk" {
  source                  = "../../../modules/beanstalk_cross_account_single"
  environment             = "${var.environment}"
  old_account             = "twitch-web-aws"
  old_account_number      = "641044725657"
  new_account_environment = "prod"
  aws_region              = "${var.region}"
  instance_type           = "c4.8xlarge"
  server_asg_max_size     = 75
  server_asg_min_size     = 10
  worker_asg_max_size     = 10
  worker_asg_min_size     = 4
  override_security_group = "${data.terraform_remote_state.aws_subnets_only.sg}"
  kinesis_stream_iam      = "arn:aws:iam::641044725657:role/user-mutations-stream-role"
  deploy_batch_size       = 25
  platform_version        = "64bit Amazon Linux 2017.09 v2.8.3 running Docker 17.06.2-ce"
}

data "terraform_remote_state" "alarms" {
  backend = "s3"

  config {
    bucket  = "${var.profile}"
    profile = "${var.profile}"
    region  = "us-west-2"
    key     = "tfstate/web/users-service/terraform/${var.environment}/${var.region}/alarms"
  }
}

module "beanstalk_alarms" {
  source                             = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//alarms?ref=v1.3.0"
  aws_region                         = "${var.region}"
  aws_profile                        = "${var.profile}"
  actions                            = ["${data.terraform_remote_state.alarms.arn}"]
  environment_name                   = "${module.beanstalk.name}"
  application_requests_5xx_threshold = "1000"
}

module "beanstalk_worker_alarms" {
  source                             = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//alarms?ref=v1.3.0"
  aws_region                         = "${var.region}"
  aws_profile                        = "${var.profile}"
  actions                            = ["${data.terraform_remote_state.alarms.arn}"]
  environment_name = "${module.beanstalk.worker_name}"
}
