terraform {
  backend "s3" {
    bucket = "twitch-users-service-prod"
    key    = "tfstate/web/users-service/terraform/production/us-west-2/db"
    region = "us-west-2"
    profile = "twitch-users-service-prod"
  }
}

module "rds" {
  name = "users-service"
  source = "../../../modules/db"
  allocated_storage = 1500
  engine = "postgres"
  engine_version = "9.5.2"
  aws_region = "${var.region}"
  environment = "production"
  new_account_environment = "prod"
  instance_type = "db.r3.large"
  storage_type = "io1"
  iops = "6000"
  username = "users_admin"
  password = "changeme"
  port = "12015"
  replica_port = "12016"
  storage_type = "io1"
  multi_az = "true"
  publicly_accessible = "false"
  backup_retention_period = "14"

  snapshot_identifier = "${var.snapshot}"
}
