terraform {
  backend "s3" {
    bucket  = "twitch-users-service-prod"
    key     = "tfstate/web/users-service/terraform/production/us-west-2/logging"
    region  = "us-west-2"
    profile = "twitch-users-service-prod"
  }
}

data "terraform_remote_state" "systems" {
  backend = "s3"

  config {
    bucket  = "twitch-users-service-prod"
    profile = "twitch-users-service-prod"
    key     = "tfstate/systems/terraform/prod/twitch-users-service-prod/terraform.tfstate"
  }
}

variable "region" {
  default = "us-west-2"
}

variable "environment" {
  default = "prod"
}

module "logging" {
  source         = "../../../modules/logging"
  logstash_addr  = "core-user-syslog.prod.us-west2.justin.tv"
  logstash_port  = "7777"
  service        = "users-service"
  environment    = "${var.environment}"
  region         = "${var.region}"
  profile        = "twitch-users-service-prod"
  source_account = "931896176507"
  source_arn     = "arn:aws:logs:${var.region}:931896176507:log-group:/aws/elasticbeanstalk/${var.environment}-web-users-service*"

  log_groups = [
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/docker",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/docker-events.log",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/eb-activity.log",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/eb-docker/containers/eb-current-app/stdouterr.log",
  ]

  subnet_ids         = "${data.terraform_remote_state.systems.private_subnets[var.region]}"
  security_group_ids = "${data.terraform_remote_state.systems.twitch_subnets_sg_id[var.region]}"
}
