module "users-service" {
  source = "../../modules/users-service"
  name = "users-service"
  owner = "cadoretti@twitch.tv"
  project = "web/users-service"
  environment = "production"
  iam_role_name = "users-service"
  kinesis_mutation_stream = "arn:aws:kinesis:us-west-2:641044725657:stream/user-mutations-stream"
  aws_profile = "twitch-web-aws"
  aws_region = "us-west-2"
}

module "users-service-legacy" {
  source = "../../modules/users-service-legacy"
  environment = "production"
  aws_region = "us-west-2"
  aws_profile = "twitch-web-aws"
}

module "asg-ec2" {
  source = "../../modules/asg-ec2"
  name = "users-service"
  hostname = "users-service"
  owner = "cadoretti@twitch.tv"
  project = "web/users-service"
  ami = "ami-dd11f3bd"
  instance_type = "c4.8xlarge"
  max_size = 80
  min_size = 10
  canary_size = 1
  environment = "production"
  root_volume_size = "256"
  iam_role_name = "users-service"
  iam_role_arn = "${module.users-service.iam_role_arn}"
  iam_role_id = "${module.users-service.iam_role_id}"
  https_certificate = "arn:aws:iam::641044725657:server-certificate/wildcard.prod.us-west2.twitch.tv"
  security_group = "${module.asg-ec2.aws_only_subnets_sg}"
}

output "elb_dns" {
  value = "${module.asg-ec2.elb_dns}"
}

output "iam_role_id" {
  value = "${module.users-service.iam_role_id}"
}

output "iam_role_arn" {
  value = "${module.users-service.iam_role_arn}"
}

resource "aws_s3_bucket" "user_default_pictures" {
  bucket = "user-default-pictures"
  acl    = "public-read"
}

resource "aws_s3_bucket_policy" "user_default_pictures_policy" {
  bucket = "${aws_s3_bucket.user_default_pictures.id}"
  policy =<<POLICY
{
    "Version": "2008-10-17",
    "Id": "cdn bucket distribution",
    "Statement": [ {
        "Sid": "readonly_policy",
        "Action": [
            "s3:GetObject"
        ],
        "Effect": "Allow",
        "Resource": "arn:aws:s3:::user-default-pictures/*",
        "Principal": {
            "AWS": [ "*" ]
        }
    } ]
}
POLICY
}
