terraform {
  backend "s3" {
    bucket  = "twitch-users-service-dev"
    key     = "tfstate/web/users-service/terraform/staging/us-east-1/beanstalk"
    region  = "us-west-2"
    profile = "twitch-users-service-dev"
  }
}

data "terraform_remote_state" "users-service" {
  backend = "s3"

  config {
    bucket  = "twitch-users-service-dev"
    profile = "twitch-users-service-dev"
    key     = "tfstate/web/users-service/terraform/staging/us-east-1"
    region  = "us-west-2"
  }
}

variable "region" {
  default = "us-east-1"
}

provider "aws" {
  region  = "${var.region}"
  profile = "twitch-users-service-dev"
}

data "aws_iam_policy_document" "users_service_cross_account" {
  statement {
    effect = "Allow"

    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "arn:aws:iam::465369119046:role/users-service",
      "arn:aws:iam::465369119046:role/user-mutations-stream-role",
    ]
  }
}

resource "aws_iam_role_policy" "users_service_cross_account" {
  name   = "users_service_cross_account"
  policy = "${data.aws_iam_policy_document.users_service_cross_account.json}"

  role = "${data.terraform_remote_state.users-service.iam_role_id}"
}

module "beanstalk" {
  source                  = "../../../modules/beanstalk_single"
  environment             = "staging"
  aws_region              = "${var.region}"
  new_account_environment = "dev"
  iam_role_id             = "${data.terraform_remote_state.users-service.iam_role_id}"
  iam_role_arn            = "${data.terraform_remote_state.users-service.iam_role_arn}"
  deploy_batch_size       = 50
  platform_version        = "64bit Amazon Linux 2017.09 v2.8.3 running Docker 17.06.2-ce"
}

# twitch-users-service-dev systems state
data "terraform_remote_state" "alarms" {
  backend = "s3"

  config {
    bucket  = "twitch-users-service-dev"
    profile = "twitch-users-service-dev"
    region  = "us-west-2"
    key     = "tfstate/web/users-service/terraform/staging/${var.region}/alarms"
  }
}

module "beanstalk_alarms" {
  source           = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//alarms?ref=v1.3.0"
  aws_region       = "${var.region}"
  aws_profile      = "twitch-users-service-dev"
  actions          = ["${data.terraform_remote_state.alarms.arn}"]
  environment_name = "${module.beanstalk.name}"
}
