module "elasticache" {
  source = "../../../modules/dualcache"
  node_type = "cache.r3.large"
  environment = "staging"
  engine = "redis"
  security_group = "${module.elasticache.twitch_subnets_sg}"
  num_node_groups = 3
  replicas_per_node_group = 2
  aws_region = "us-east-1"
}

terraform {
  backend "s3" {
    bucket = "twitch-users-service-dev"
    key    = "tfstate/web/users-service/terraform/staging/us-east-1/cache"
    region = "us-west-2"
    profile = "twitch-users-service-dev"
  }
}

