terraform {
  backend "s3" {
    bucket  = "twitch-users-service-dev"
    key     = "tfstate/web/users-service/terraform/staging/us-east-1/logging"
    region  = "us-west-2"
    profile = "twitch-users-service-dev"
  }
}

data "terraform_remote_state" "systems" {
  backend = "s3"

  config {
    bucket  = "twitch-users-service-dev"
    profile = "twitch-users-service-dev"
    key     = "tfstate/systems/terraform/dev/twitch-users-service-dev/terraform.tfstate"
  }
}

variable "region" {
  default = "us-east-1"
}

variable "environment" {
  default = "staging"
}

module "logging" {
  source         = "../../../modules/logging"
  logstash_addr  = "core-user-syslog.dev.us-west2.justin.tv"
  logstash_port  = "7777"
  service        = "users-service"
  environment    = "${var.environment}"
  region         = "${var.region}"
  profile        = "twitch-users-service-dev"
  source_account = "404788901388"
  source_arn     = "arn:aws:logs:${var.region}:404788901388:log-group:/aws/elasticbeanstalk/${var.environment}-web-users-service*"

  log_groups = [
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/docker",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/docker-events.log",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/eb-activity.log",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/eb-docker/containers/eb-current-app/stdouterr.log",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/nginx/access.log",
    "/aws/elasticbeanstalk/${var.environment}-web-users-service-server/var/log/nginx/error.log",
  ]

  subnet_ids         = "${data.terraform_remote_state.systems.private_subnets[var.region]}"
  security_group_ids = "${data.terraform_remote_state.systems.twitch_subnets_sg_id[var.region]}"
}
