terraform {
  backend "s3" {
    bucket  = "twitch-users-service-dev"
    key     = "tfstate/web/users-service/terraform/staging/us-west-2/beanstalk"
    region  = "us-west-2"
    profile = "twitch-users-service-dev"
  }
}

module "beanstalk" {
  source                  = "../../../modules/beanstalk_cross_account_single"
  environment             = "staging"
  old_account             = "twitch-web-dev"
  old_account_number      = "465369119046"
  new_account_environment = "dev"
  aws_region              = "us-west-2"
  deploy_batch_size       = 50
  kinesis_stream_iam      = "arn:aws:iam::465369119046:role/user-mutations-stream-role"
  platform_version        = "64bit Amazon Linux 2017.09 v2.8.3 running Docker 17.06.2-ce"
}

# twitch-users-service-dev systems state
data "terraform_remote_state" "alarms" {
  backend = "s3"

  config {
    bucket  = "twitch-users-service-dev"
    profile = "twitch-users-service-dev"
    region  = "us-west-2"
    key     = "tfstate/web/users-service/terraform/staging/us-west-2/alarms"
  }
}

module "beanstalk_alarms" {
  source           = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//alarms?ref=v1.3.0"
  aws_region       = "us-west-2"
  aws_profile      = "twitch-users-service-dev"
  actions          = ["${data.terraform_remote_state.alarms.arn}"]
  environment_name = "${module.beanstalk.name}"
}

module "beanstalk_worker_alarms" {
  source           = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//alarms?ref=v1.3.0"
  aws_region       = "us-west-2"
  aws_profile      = "twitch-users-service-dev"
  actions          = ["${data.terraform_remote_state.alarms.arn}"]
  environment_name = "${module.beanstalk.worker_name}"
}
