terraform {
  backend "s3" {
    bucket  = "twitch-web-dev"
    key     = "tfstate/web/users-service/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-web-dev"
  }
}


module "users-service" {
  source = "../../modules/users-service"
  name = "users-service"
  owner = "cadoretti@twitch.tv"
  project = "web/users-service"
  environment = "staging"
  iam_role_name = "users-service"
  kinesis_mutation_stream = "arn:aws:kinesis:us-west-2:465369119046:stream/user-mutations-stream"
  aws_region = "us-west-2"
  aws_profile = "twitch-web-dev"
}

module "users-service-legacy" {
  source = "../../modules/users-service-legacy"
  environment = "staging"
  aws_region = "us-west-2"
  aws_profile = "twitch-web-dev"
}

output "iam_role_id" {
  value = "${module.users-service.iam_role_id}"
}

output "iam_role_arn" {
  value = "${module.users-service.iam_role_arn}"
}
